<?php
require_once 'madeline.php';
use danog\MadelineProto\API;

// Load Telegram session
$MadelineProto = new API('session.madeline');
$MadelineProto->start();

/*
----------------------------------------------------------
 This file has TWO purposes:
 1️⃣ Respond to Telegram’s verification ping
 2️⃣ Allow Telegram’s CDN (getDownloadLink) to verify access
----------------------------------------------------------
*/

// Case 1️⃣: Verification ping (when no ?file or ?f)
if (!isset($_GET['file']) && !isset($_GET['f'])) {
    try {
        $session = $MadelineProto->getSelf();
        $sessionId = $session['id'] ?? 0;
    } catch (Throwable $e) {
        $sessionId = 0;
    }

    header('Content-Type: text/plain');
    echo $sessionId; // must output ONLY numeric id
    exit;
}

// Case 2️⃣: Called by Telegram’s getDownloadLink (verification)
if (isset($_GET['f'])) {
    // Telegram’s verification request — must respond with 200 OK
    header('Content-Type: text/plain');
    echo "OK";
    exit;
}

// Case 3️⃣: Block all other direct hits
http_response_code(403);
exit("Forbidden");
